

<?php $__env->startSection('title', 'Loading Server...'); ?>

<?php
$steamPlayer = null;
$steamApiKey = config_value('steam_apikey');

if (!empty($steamId) && !empty($steamApiKey)) {
    try {
        $steam64Id = $steamId;
        
        if (preg_match('/^STEAM_[0-5]:[01]:\d+$/', $steamId)) {
            preg_match('/^STEAM_[0-5]:([01]):(\d+)$/', $steamId, $matches);
            $steam64Id = bcadd(bcadd(bcmul($matches[2], '2'), $matches[1]), '76561197960265728');
        }
        
        $apiUrl = "http://api.steampowered.com/ISteamUser/GetPlayerSummaries/v0002/?key={$steamApiKey}&steamids={$steam64Id}";
        
        $context = stream_context_create([
            'http' => [
                'timeout' => 5,
                'method' => 'GET',
                'header' => 'User-Agent: Loading Screen'
            ]
        ]);
        
        $response = @file_get_contents($apiUrl, false, $context);
        
        if ($response !== false) {
            $data = json_decode($response, true);
            
            if (isset($data['response']['players']) && !empty($data['response']['players'])) {
                $steamPlayer = $data['response']['players'][0];
            }
        }
    } catch (Exception $e) {
        // Silently fail
        error_log('Steam API request failed: ' . $e->getMessage());
        $steamPlayer = null;
    }
}

$playerName = 'Loading...';
$playerAvatar = asset('images/default-avatar.jpg');
$playerStatus = null;

if ($steamPlayer) {
    $playerName = $steamPlayer['personaname'] ?? 'Unknown Player';
    $playerAvatar = $steamPlayer['avatarfull'] ?? $steamPlayer['avatarmedium'] ?? $steamPlayer['avatar'] ?? asset('images/default-avatar.jpg');
    
    if (isset($steamPlayer['personastate'])) {
        $statusMap = [
            0 => 'Offline',
            1 => 'Online',
            2 => 'Busy',
            3 => 'Away',
            4 => 'Snooze',
            5 => 'Looking to trade',
            6 => 'Looking to play'
        ];
        $playerStatus = $statusMap[$steamPlayer['personastate']] ?? 'Unknown';
    }
}
?>

<?php $__env->startSection('content'); ?>
<div class="loading-screen" 
    <?php if($settings->background_image): ?>
        style="background-image: url('<?php echo e(asset('storage/' . $settings->background_image)); ?>');"
    <?php endif; ?>
>
    <div class="loading-screen-overlay"></div>
    
    <div class="loading-container">
        <div class="loading-header">
            <?php if($settings->logo): ?>
                <div class="server-logo">
                    <img src="<?php echo e(asset('storage/' . $settings->logo)); ?>" alt="Server Logo">
                </div>
            <?php endif; ?>
            
            <div class="server-name">
                <h1><?php echo e(config_value('site_name')); ?></h1>
                <div class="server-tagline">Welcome!</div>
            </div>
        </div>
        
        <?php if($settings->enable_loading_bar): ?>
        <div class="loading-progress">
            <div class="loading-bar-container">
                <div class="loading-bar" id="loading-bar"></div>
            </div>
            <div class="loading-status-container">
                <div class="loading-percentage" id="loading-percentage">0%</div>
                <div class="loading-status" id="loading-status">Connecting to server...</div>
            </div>
        </div>
        <?php endif; ?>
        
        <div class="loading-grid" id="loading-grid">
                        <?php
                $leftColumnEnabled = $settings->enable_map_info || $settings->enable_community_links;
                $rightColumnEnabled = $settings->enable_player_info || ($settings->enable_server_info && is_array($settings->server_rules) && count($settings->server_rules) > 0);
                
                $gridClass = '';
                if ($leftColumnEnabled && $rightColumnEnabled) {
                    $gridClass = 'grid-two-columns';
                } else {
                    $gridClass = 'grid-one-column';
                }
            ?>
            
            <?php if(!$leftColumnEnabled && !$rightColumnEnabled): ?>
            <style>
                .loading-container {
                    justify-content: flex-start;
                }
                
                .loading-progress {
                    margin-top: auto;
                    margin-bottom: auto;
                }
                
                .loading-footer {
                    margin-top: auto;
                }
            </style>
            <?php endif; ?>
            
            <div class="loading-grid-inner <?php echo e($gridClass); ?>">
                <?php if($leftColumnEnabled): ?>
                <div class="loading-column">
                    <?php if($settings->enable_map_info): ?>
                    <div class="loading-card map-card">
                        <div class="card-header">
                            <i class="fas fa-map-marked-alt"></i>
                            <h2>Current Map</h2>
                        </div>
                        <div class="map-content">
                            <div class="map-name">
                                <span id="map-name"><?php echo e($map); ?></span>
                            </div>
                            <div class="map-image">
                                <img src="<?php echo e(asset('images/maps/' . $map . '.jpg')); ?>" alt="<?php echo e($map); ?>" onerror="this.src='<?php echo e(asset('images/maps/default.jpg')); ?>'">
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if($settings->enable_community_links && is_array($settings->community_links) && count($settings->community_links) > 0): ?>
                    <div class="loading-card links-card">
                        <div class="card-header">
                            <i class="fas fa-link"></i>
                            <h2>Community Links</h2>
                        </div>
                        <div class="links-grid">
                            <?php $__currentLoopData = $settings->community_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e($link['url']); ?>" class="community-link" target="_blank">
                                    <i class="<?php echo e($link['icon']); ?>"></i>
                                    <span><?php echo e($link['name']); ?></span>
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                
                <?php if($rightColumnEnabled): ?>
                <div class="loading-column">
                    <?php if($settings->enable_player_info): ?>
                    <div class="loading-card player-card">
                        <div class="card-header">
                            <i class="fas fa-user-circle"></i>
                            <h2>Player Info</h2>
                        </div>
                        <div class="player-content">
                            <div class="player-avatar">
                                <img id="steam-avatar" src="<?php echo e($playerAvatar); ?>" alt="Steam Avatar">
                                <?php if($playerStatus): ?>
                                    <div class="status-indicator status-<?php echo e(strtolower(str_replace(' ', '-', $playerStatus))); ?>"></div>
                                <?php endif; ?>
                            </div>
                            <div class="player-details">
                                <div class="player-name" id="steam-name"><?php echo e($playerName); ?></div>
                                <?php if($playerStatus): ?>
                                    <div class="player-status">Status: <span class="status-text"><?php echo e($playerStatus); ?></span></div>
                                <?php endif; ?>
                                <div class="player-steamid">SteamID: <span id="steam-id"><?php echo e($steamId); ?></span></div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <?php if($settings->enable_server_info && is_array($settings->server_rules) && count($settings->server_rules) > 0): ?>
                    <div class="loading-card rules-card">
                        <div class="card-header">
                            <i class="fas fa-gavel"></i>
                            <h2>Server Rules</h2>
                        </div>
                        <ul class="rules-list">
                            <?php $__currentLoopData = $settings->server_rules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($rule); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="loading-footer">
            <?php if($settings->enable_tips && is_array($settings->tips) && count($settings->tips) > 0): ?>
            <div class="tip-container">
                <i class="fas fa-lightbulb"></i>
                <div class="tip" id="current-tip"><?php echo e($settings->tips[0]); ?></div>
            </div>
            <?php endif; ?>
            
            <?php if($settings->enable_music && $settings->music_file): ?>
            <div class="music-controls">
                <button id="toggle-music" class="music-toggle-btn">
                    <i class="fas fa-volume-up"></i>
                </button>
                <div class="music-info">
                    <div class="music-name">
                        <span>Music:</span> 
                        <span id="music-title">
                            <?php
                                $filename = basename($settings->music_file);
                                $songName = pathinfo($filename, PATHINFO_FILENAME);
                                echo $songName;
                            ?>
                        </span>
                    </div>
                    <div class="music-volume">
                        <input type="range" id="music-volume" min="0" max="1" step="0.1" value="0.5">
                    </div>
                </div>
                <audio id="background-music" loop autoplay>
                    <source src="<?php echo e(asset('storage/' . $settings->music_file)); ?>" type="audio/mpeg">
                </audio>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
:root {
    --primary-color: <?php echo e($settings->primary_color ?? '#4B8BFF'); ?>;
    --primary-rgb: <?php echo e(hexToRgb($settings->primary_color ?? '#4B8BFF')); ?>;
    --primary-dark: <?php echo e(adjustBrightness($settings->primary_color ?? '#4B8BFF', -20)); ?>;
    --primary-light: <?php echo e(adjustBrightness($settings->primary_color ?? '#4B8BFF', 20)); ?>;
    
    --dark-gray: #1E1E1E;
    --dark-gray-lighter: #2A2A2A;
    --dark-gray-lightest: #333333;
    --mid-gray: #606060;
    --light-gray: #9A9A9A;
    --lighter-gray: #E0E0E0;
    
    --text-color: #FFFFFF;
    --text-secondary: #9A9A9A;
    
    --spacing-xs: 0.25rem;
    --spacing-sm: 0.5rem;
    --spacing-md: 1rem;
    --spacing-lg: 1.5rem;
    --spacing-xl: 2rem;
    
    --border-radius-sm: 0.25rem;
    --border-radius-md: 0.5rem;
    --border-radius-lg: 0.75rem;
    
    --box-shadow-sm: 0 2px 4px rgba(0, 0, 0, 0.1);
    --box-shadow-md: 0 4px 8px rgba(0, 0, 0, 0.2);
    --box-shadow-lg: 0 8px 16px rgba(0, 0, 0, 0.3);
    
    --transition-base: all 0.3s ease;
    --transition-fast: all 0.15s ease;
}

/* Base styles */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Poppins', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
    background-color: var(--dark-gray);
    color: var(--text-color);
    line-height: 1.6;
    overflow: hidden;
    height: 100vh;
}

/* Loading Screen Container */
.loading-screen {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: var(--dark-gray);
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
}

.loading-screen-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, 
        rgba(30, 30, 30, 0.85) 0%, 
        rgba(30, 30, 30, 0.75) 50%, 
        rgba(30, 30, 30, 0.85) 100%
    );
}

.loading-container {
    position: relative;
    z-index: 1;
    width: 100%;
    max-width: 1200px;
    padding: var(--spacing-xl);
    display: flex;
    flex-direction: column;
    height: 100vh;
    max-height: 900px;
    justify-content: space-between;
}

/* Header Section */
.loading-header {
    text-align: center;
    margin-bottom: var(--spacing-xl);
    animation: fadeInDown 0.8s ease-out;
}

.server-logo {
    margin-bottom: var(--spacing-lg);
}

.server-logo img {
    max-height: 100px;
    filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.3));
}

.server-name h1 {
    font-size: 3rem;
    font-weight: 700;
    color: var(--text-color);
    margin-bottom: var(--spacing-xs);
    text-transform: uppercase;
    letter-spacing: 1px;
    background: linear-gradient(135deg, var(--primary-color), var(--primary-light));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.5);
}

.server-tagline {
    font-size: 1.2rem;
    color: var(--text-secondary);
    font-weight: 300;
}

/* Loading Bar */
.loading-progress {
    width: 100%;
    max-width: 800px;
    margin: 0 auto var(--spacing-xl);
    animation: fadeIn 0.8s ease-out 0.2s both;
}

.loading-bar-container {
    height: 8px;
    background: rgba(60, 60, 60, 0.5);
    border-radius: 4px;
    overflow: hidden;
    box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.3);
    margin-bottom: var(--spacing-sm);
}

.loading-bar {
    height: 100%;
    width: 0%;
    background: linear-gradient(90deg, var(--primary-dark), var(--primary-color));
    border-radius: 4px;
    transition: width 0.3s ease;
    position: relative;
}

.loading-bar::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(
        90deg,
        transparent,
        rgba(255, 255, 255, 0.3),
        transparent
    );
    animation: shine 2s infinite;
}

.loading-status-container {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.loading-percentage {
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--primary-color);
}

.loading-status {
    font-size: 0.9rem;
    color: var(--text-secondary);
}

/* Main Content Grid */
.loading-grid {
    width: 100%;
    max-width: 1000px;
    margin: 0 auto var(--spacing-xl);
    animation: fadeIn 0.8s ease-out 0.4s both;
}

.loading-grid-inner {
    display: grid;
    gap: var(--spacing-lg);
}

.loading-grid-inner.grid-two-columns {
    grid-template-columns: 1fr 1fr;
}

.loading-grid-inner.grid-one-column {
    grid-template-columns: 1fr;
    max-width: 600px;
    margin: 0 auto;
}

.loading-column {
    display: flex;
    flex-direction: column;
    gap: var(--spacing-lg);
}

/* Cards */
.loading-card {
    background: var(--dark-gray-lighter);
    border-radius: var(--border-radius-md);
    border: 1px solid rgba(255, 255, 255, 0.05);
    overflow: hidden;
    box-shadow: var(--box-shadow-md);
    transition: var(--transition-base);
    height: 100%;
    display: flex;
    flex-direction: column;
}

.loading-card:hover {
    transform: translateY(-4px);
    box-shadow: var(--box-shadow-lg);
    border-color: rgba(75, 139, 255, 0.3);
}

.card-header {
    background: var(--dark-gray-lightest);
    padding: var(--spacing-md);
    display: flex;
    align-items: center;
    border-bottom: 1px solid rgba(255, 255, 255, 0.05);
}

.card-header i {
    font-size: 1.1rem;
    color: var(--primary-color);
    margin-right: var(--spacing-sm);
}

.card-header h2 {
    font-size: 1.1rem;
    font-weight: 600;
    color: var(--text-color);
    margin: 0;
}

/* Map Card */
.map-content {
    padding: var(--spacing-md);
    flex: 1;
}

.map-name {
    font-size: 1.3rem;
    font-weight: 700;
    color: var(--primary-color);
    margin-bottom: var(--spacing-md);
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.map-image {
    border-radius: var(--border-radius-sm);
    overflow: hidden;
    box-shadow: var(--box-shadow-md);
}

.map-image img {
    width: 100%;
    height: 180px;
    object-fit: cover;
    transition: var(--transition-base);
}

.map-image:hover img {
    transform: scale(1.05);
}

/* Player Card */
.player-content {
    padding: var(--spacing-md);
    display: flex;
    align-items: center;
    gap: var(--spacing-md);
}

.player-avatar {
    position: relative;
    width: 80px;
    height: 80px;
    border-radius: 50%;
    overflow: hidden;
    border: 3px solid var(--primary-color);
    box-shadow: 0 0 0 2px rgba(75, 139, 255, 0.3);
    flex-shrink: 0;
}

.player-avatar img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.status-indicator {
    position: absolute;
    bottom: 0;
    right: 0;
    width: 16px;
    height: 16px;
    border-radius: 50%;
    border: 2px solid var(--dark-gray-lighter);
    background-color: #757575;
}

.status-indicator.status-online {
    background-color: #4CD964;
}

.status-indicator.status-offline {
    background-color: #757575;
}

.status-indicator.status-busy {
    background-color: #FF3B30;
}

.status-indicator.status-away {
    background-color: #FF9500;
}

.player-details {
    flex: 1;
}

.player-name {
    font-size: 1.2rem;
    font-weight: 600;
    color: var(--text-color);
    margin-bottom: var(--spacing-xs);
}

.player-status {
    font-size: 0.9rem;
    color: var(--text-secondary);
    margin-bottom: var(--spacing-xs);
}

.status-text {
    color: var(--primary-color);
    font-weight: 500;
}

.player-steamid {
    font-size: 0.8rem;
    color: var(--text-secondary);
    font-family: 'Courier New', monospace;
}

/* Rules Card */
.rules-list {
    list-style: none;
    padding: var(--spacing-md);
    flex: 1;
    overflow-y: auto;
    max-height: 300px;
}

.rules-list li {
    position: relative;
    padding: var(--spacing-sm) 0 var(--spacing-sm) var(--spacing-lg);
    color: var(--text-color);
    border-bottom: 1px solid rgba(255, 255, 255, 0.05);
    transition: var(--transition-base);
}

.rules-list li:last-child {
    border-bottom: none;
}

.rules-list li::before {
    content: '';
    position: absolute;
    left: 0;
    top: 50%;
    transform: translateY(-50%);
    width: 6px;
    height: 6px;
    background: var(--primary-color);
    border-radius: 50%;
}

.rules-list li:hover {
    color: var(--primary-light);
    background: rgba(75, 139, 255, 0.05);
    padding-left: calc(var(--spacing-lg) + var(--spacing-xs));
}

/* Links Card */
.links-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(160px, 1fr));
    gap: var(--spacing-sm);
    padding: var(--spacing-md);
}

.community-link {
    display: flex;
    align-items: center;
    justify-content: center;
    gap: var(--spacing-xs);
    padding: var(--spacing-sm);
    background: var(--dark-gray);
    border-radius: var(--border-radius-sm);
    border: 1px solid rgba(255, 255, 255, 0.05);
    color: var(--text-color);
    text-decoration: none;
    transition: var(--transition-base);
}

.community-link:hover {
    background: var(--primary-color);
    transform: translateY(-2px);
    box-shadow: var(--box-shadow-sm);
}

.community-link i {
    font-size: 1rem;
    color: var(--primary-color);
    transition: var(--transition-base);
}

.community-link:hover i {
    color: var(--text-color);
}

/* Footer */
.loading-footer {
    display: flex;
    justify-content: space-between;
    align-items: center;
    gap: var(--spacing-lg);
    animation: fadeInUp 0.8s ease-out 0.6s both;
    width: 100%;
    max-width: 1000px;
    margin: 0 auto;
}

.tip-container {
    flex: 1;
    display: flex;
    align-items: center;
    gap: var(--spacing-md);
    background: var(--dark-gray-lighter);
    border-radius: var(--border-radius-md);
    padding: var(--spacing-md);
    border: 1px solid rgba(255, 255, 255, 0.05);
}

.tip-container i {
    color: var(--primary-color);
    font-size: 1.1rem;
    animation: pulse 2s infinite;
}

.tip {
    color: var(--text-color);
    font-style: italic;
    transition: opacity 0.3s ease;
}

.music-controls {
    display: flex;
    align-items: center;
    gap: var(--spacing-md);
    background: var(--dark-gray-lighter);
    border-radius: var(--border-radius-md);
    padding: var(--spacing-sm) var(--spacing-md);
    border: 1px solid rgba(255, 255, 255, 0.05);
    min-width: 280px;
}

.music-toggle-btn {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    background: var(--primary-color);
    border: none;
    color: white;
    cursor: pointer;
    transition: var(--transition-base);
    flex-shrink: 0;
}

.music-toggle-btn:hover {
    background: var(--primary-dark);
    transform: scale(1.1);
}

.music-toggle-btn.muted {
    background: var(--text-secondary);
}

.music-info {
    flex: 1;
    min-width: 0;
}

.music-name {
    font-size: 0.9rem;
    color: var(--text-color);
    margin-bottom: var(--spacing-xs);
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.music-name span:first-child {
    font-weight: 600;
    color: var(--primary-color);
}

.music-volume {
    width: 100%;
}

#music-volume {
    width: 100%;
    height: 4px;
    background: var(--dark-gray);
    border-radius: 2px;
    appearance: none;
    outline: none;
    cursor: pointer;
}

#music-volume::-webkit-slider-thumb {
    appearance: none;
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background: var(--primary-color);
    cursor: pointer;
    transition: var(--transition-base);
}

#music-volume::-webkit-slider-thumb:hover {
    transform: scale(1.2);
}

/* Animations */
@keyframes fadeInDown {
    from {
        opacity: 0;
        transform: translateY(-20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.6; }
}

@keyframes shine {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

/* Scrollbar */
::-webkit-scrollbar {
    width: 6px;
}

::-webkit-scrollbar-track {
    background: var(--dark-gray);
    border-radius: 3px;
}

::-webkit-scrollbar-thumb {
    background: var(--primary-color);
    border-radius: 3px;
}

::-webkit-scrollbar-thumb:hover {
    background: var(--primary-light);
}

/* Responsive Design */
@media (max-width: 1200px) {
    .loading-container {
        padding: var(--spacing-lg);
    }
    
    .server-name h1 {
        font-size: 2.5rem;
    }
}

@media (max-width: 992px) {
    .loading-grid-inner.grid-two-columns {
        grid-template-columns: 1fr;
    }
    
    .loading-card {
        max-height: none;
    }
    
    .player-content {
        flex-direction: column;
        text-align: center;
    }
    
    .player-avatar {
        margin: 0 auto;
    }
    
    .server-name h1 {
        font-size: 2rem;
    }
    
    .server-tagline {
        font-size: 1rem;
    }
}

@media (max-width: 768px) {
    .loading-container {
        padding: var(--spacing-md);
    }
    
    .loading-footer {
        flex-direction: column;
        gap: var(--spacing-md);
    }
    
    .server-logo img {
        max-height: 80px;
    }
    
    .loading-progress {
        margin-bottom: var(--spacing-lg);
    }
    
    .loading-status-container {
        flex-direction: column;
        align-items: flex-start;
        gap: var(--spacing-xs);
    }
    
    .links-grid {
        grid-template-columns: 1fr 1fr;
    }
    
    .music-controls {
        min-width: unset;
        width: 100%;
    }
}

@media (max-width: 480px) {
    .server-name h1 {
        font-size: 1.8rem;
    }
    
    .links-grid {
        grid-template-columns: 1fr;
    }
    
    .map-name {
        font-size: 1.1rem;
    }
    
    .loading-card {
        margin-bottom: var(--spacing-sm);
    }
    
    .card-header h2 {
        font-size: 1rem;
    }
}

/* Screen height adjustments */
@media (max-height: 800px) {
    .loading-container {
        padding-top: var(--spacing-md);
        padding-bottom: var(--spacing-md);
    }
    
    .loading-header {
        margin-bottom: var(--spacing-md);
    }
    
    .server-logo img {
        max-height: 70px;
    }
    
    .server-name h1 {
        font-size: 2rem;
    }
    
    .rules-list {
        max-height: 150px;
    }
    
    .map-image img {
        height: 140px;
    }
}

@media (max-height: 600px) {
    .loading-grid {
        gap: var(--spacing-sm);
    }
    
    .loading-column {
        gap: var(--spacing-sm);
    }
    
    .card-header {
        padding: var(--spacing-sm);
    }
    
    .map-content, 
    .player-content {
        padding: var(--spacing-sm);
    }
    
    .rules-list {
        padding: var(--spacing-sm);
        max-height: 120px;
    }
    
    .map-name {
        margin-bottom: var(--spacing-sm);
    }
    
    .map-image img {
        height: 100px;
    }
}

/* Custom CSS from admin panel */
<?php echo $settings->custom_css ?? ''; ?>

</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const tips = <?php echo json_encode($settings->tips ?? [], 15, 512) ?>;
    const enableMusic = <?php echo json_encode($settings->enable_music ?? false, 15, 512) ?>;
    const musicVolume = <?php echo json_encode($settings->music_volume ?? 0.5, 15, 512) ?>;
    const steamId = "<?php echo e($steamId); ?>";
    const mapName = "<?php echo e($map); ?>";
    
    let loadingProgress = 0;
    let isInGmod = typeof window.GameDetails !== 'undefined';
    
    if (enableMusic) {
        initializeMusic();
    }
    
    if (tips && tips.length > 0) {
        initializeTips();
    }
    
    if (!isInGmod) {
        simulateLoading();
    }
    
    window.GameDetails = function(servername, serverurl, mapname, maxplayers, steamid, gamemode) {
        const serverNameElements = document.querySelectorAll('.server-name h1');
        if (serverNameElements.length > 0 && servername) {
            serverNameElements[0].textContent = servername;
        }
        
        const mapElement = document.getElementById('map-name');
        if (mapElement && mapname) {
            mapElement.textContent = mapname;
            
            const mapImage = document.querySelector('.map-image img');
            if (mapImage) {
                mapImage.src = '<?php echo e(asset('images/maps')); ?>/' + mapname + '.jpg';
                mapImage.onerror = function() {
                    this.src = '<?php echo e(asset('images/maps/default.jpg')); ?>';
                };
            }
        }
        
        const steamIdElement = document.getElementById('steam-id');
        if (steamIdElement && steamid) {
            steamIdElement.textContent = steamid;
        }
    };
    
    window.SetStatusChanged = function(status) {
        const statusElement = document.getElementById('loading-status');
        if (statusElement) {
            statusElement.textContent = status;
        }
    };
    
    window.SetFilesTotal = function(total) {
        window.filesTotal = total;
    };
    
    window.SetFilesNeeded = function(needed) {
        window.filesNeeded = needed;
    };
    
    window.DownloadingFile = function(fileName) {
        const statusElement = document.getElementById('loading-status');
        if (statusElement) {
            statusElement.textContent = "Downloading: " + fileName;
        }
    };
    
    window.DownloadProgress = function(downloaded, total) {
        const progress = Math.floor((downloaded / total) * 100);
        updateProgressBar(progress);
    };
    
    function initializeMusic() {
        const audio = document.getElementById('background-music');
        const toggleBtn = document.getElementById('toggle-music');
        const volumeSlider = document.getElementById('music-volume');
        
        if (!audio) return;
        
        audio.volume = musicVolume;
        if (volumeSlider) volumeSlider.value = musicVolume;
        
        audio.play().then(() => {
            if (toggleBtn) {
                toggleBtn.classList.remove('muted');
                toggleBtn.innerHTML = '<i class="fas fa-volume-up"></i>';
            }
        }).catch(error => {
            console.log('Audio autoplay failed:', error);
            
            document.addEventListener('click', function() {
                audio.play().then(() => {
                    if (toggleBtn) {
                        toggleBtn.classList.remove('muted');
                        toggleBtn.innerHTML = '<i class="fas fa-volume-up"></i>';
                    }
                }).catch(error => {
                    console.log('Audio play failed:', error);
                });
            }, { once: true });
        });
        
        if (toggleBtn) {
            toggleBtn.addEventListener('click', function() {
                if (audio.paused) {
                    audio.play();
                    this.classList.remove('muted');
                    this.innerHTML = '<i class="fas fa-volume-up"></i>';
                } else {
                    audio.pause();
                    this.classList.add('muted');
                    this.innerHTML = '<i class="fas fa-volume-mute"></i>';
                }
            });
        }
        
        if (volumeSlider) {
            volumeSlider.addEventListener('input', function() {
                audio.volume = this.value;
                
                if (toggleBtn) {
                    if (this.value == 0) {
                        toggleBtn.innerHTML = '<i class="fas fa-volume-mute"></i>';
                    } else if (this.value < 0.5) {
                        toggleBtn.innerHTML = '<i class="fas fa-volume-down"></i>';
                    } else {
                        toggleBtn.innerHTML = '<i class="fas fa-volume-up"></i>';
                    }
                }
            });
        }
    }
    
    // Tips rotation
    function initializeTips() {
        const tipElement = document.getElementById('current-tip');
        if (!tipElement || tips.length === 0) return;
        
        let currentTipIndex = 0;
        
        function rotateTips() {
            tipElement.style.opacity = '0';
            
            setTimeout(() => {
                currentTipIndex = (currentTipIndex + 1) % tips.length;
                tipElement.textContent = tips[currentTipIndex];
                tipElement.style.opacity = '1';
            }, 300);
        }
        
        // Rotate tips every 8 seconds
        setInterval(rotateTips, 8000);
    }
    
    function updateProgressBar(progress) {
        const loadingBar = document.getElementById('loading-bar');
        const percentage = document.getElementById('loading-percentage');
        
        if (loadingBar) {
            loadingBar.style.width = Math.min(100, Math.max(0, progress)) + '%';
        }
        
        if (percentage) {
            percentage.textContent = Math.min(100, Math.max(0, progress)) + '%';
        }
    }
    
    function simulateLoading() {
        const statuses = [
            "Connecting to server...",
            "Validating game content...",
            "Downloading server content...",
            "Initializing game rules...",
            "Preparing environment...",
            "Almost there...",
            "Joining server..."
        ];
        
        let statusIndex = 0;
        
        const progressInterval = setInterval(function() {
            loadingProgress += Math.floor(Math.random() * 3) + 1;
            
            if (loadingProgress >= 100) {
                loadingProgress = 100;
                clearInterval(progressInterval);
                document.getElementById('loading-status').textContent = "Joining server...";
            }
            
            updateProgressBar(loadingProgress);
        }, 150);
        
        const statusInterval = setInterval(function() {
            if (statusIndex < statuses.length - 1 && loadingProgress < 100) {
                document.getElementById('loading-status').textContent = statuses[statusIndex];
                statusIndex++;
            } else {
                clearInterval(statusInterval);
            }
        }, 2000);
    }
    
    <?php echo $settings->custom_js ?? ''; ?>

});
</script>
<?php $__env->stopSection(); ?>

<?php
function hexToRgb($hex) {
    $hex = ltrim($hex, '#');
    $r = hexdec(substr($hex, 0, 2));
    $g = hexdec(substr($hex, 2, 2));
    $b = hexdec(substr($hex, 4, 2));
    return "$r,$g,$b";
}

function adjustBrightness($hex, $percent) {
    $hex = ltrim($hex, '#');
    $r = hexdec(substr($hex, 0, 2));
    $g = hexdec(substr($hex, 2, 2));
    $b = hexdec(substr($hex, 4, 2));
    
    $r = max(0, min(255, $r + ($r * $percent / 100)));
    $g = max(0, min(255, $g + ($g * $percent / 100)));
    $b = max(0, min(255, $b + ($b * $percent / 100)));
    
    return '#' . str_pad(dechex($r), 2, '0', STR_PAD_LEFT) . 
                str_pad(dechex($g), 2, '0', STR_PAD_LEFT) . 
                str_pad(dechex($b), 2, '0', STR_PAD_LEFT);
}
?>
<?php echo $__env->make('layouts.minimal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/loading.blade.php ENDPATH**/ ?>